#!/usr/bin/env python3
"""
Test der Springer-Zuggenerierung
"""

from engine import ChesstegEngine

def test_knight_moves():
    print("=== TESTING KNIGHT MOVES ===")
    
    engine = ChesstegEngine()
    
    # Finde beide Springer
    white_knights = [p for p in engine.pieces if p['type'] == 4 and p['color'] == 1]
    black_knights = [p for p in engine.pieces if p['type'] == 4 and p['color'] == -1]
    
    print(f"Weiße Springer: {len(white_knights)}")
    print(f"Schwarze Springer: {len(black_knights)}")
    
    for knight in white_knights + black_knights:
        color = "White" if knight['color'] == 1 else "Black"
        position = engine._position_to_notation(knight['pos'])
        moves = engine.generate_piece_moves(knight)
        
        move_notations = [engine._position_to_notation(m['to_pos']) for m in moves]
        print(f"{color} Knight at {position}: {len(moves)} moves -> {move_notations}")

if __name__ == "__main__":
    test_knight_moves()