#!/usr/bin/env python3
"""
Test der Engine-Module
"""

import os
import sys

def check_files():
    """Prüft ob alle Engine-Dateien existieren"""
    engine_dir = "engine"
    required_files = [
        "__init__.py",
        "core.py", 
        "move_generation.py",
        "evaluation.py",
        "search.py",
        "rules.py"
    ]
    
    print("=== CHECKING ENGINE FILES ===")
    
    for file in required_files:
        path = os.path.join(engine_dir, file)
        if os.path.exists(path):
            print(f"✅ {file}")
        else:
            print(f"❌ {file} - FEHLT!")
    
    print()

def test_imports():
    """Testet ob Imports funktionieren"""
    print("=== TESTING IMPORTS ===")
    
    try:
        from engine import ChesstegEngine
        print("✅ ChesstegEngine importiert")
        
        engine = ChesstegEngine()
        print("✅ Engine Instanz erstellt")
        
        moves = engine.generate_moves(1)
        print(f"✅ Züge generiert: {len(moves)}")
        
        return True
        
    except Exception as e:
        print(f"❌ IMPORT FEHLER: {e}")
        return False

if __name__ == "__main__":
    check_files()
    test_imports()