#!/usr/bin/env python3
"""
Test-Skript für KI-Funktionalität
"""

from engine.core import ChesstegEngine

def test_ki_basic():
    """Testet grundlegende KI-Funktionalität"""
    print("=== KI BASIS-TEST ===")
    
    engine = ChesstegEngine()
    
    # Test 1: Zuggenerierung
    print("1. Zuggenerierung testen...")
    moves_white = engine.generate_all_moves(1)
    moves_black = engine.generate_all_moves(-1)
    print(f"   Weiß: {len(moves_white)} Züge, Schwarz: {len(moves_black)} Züge")
    
    # Test 2: Bewertungsfunktion
    print("2. Bewertungsfunktion testen...")
    evaluation = engine.evaluator.evaluate_position()
    print(f"   Startstellung Bewertung: {evaluation}")
    
    # Test 3: Einfachen Zug machen und neu bewerten
    print("3. Nach Zug e2-e4 bewerten...")
    move = next((m for m in moves_white if m['from_pos'] == 32 and m['to_pos'] == 52), None)
    if move:
        engine.make_move(move)
        evaluation_after = engine.evaluator.evaluate_position()
        print(f"   Bewertung nach e2-e4: {evaluation_after}")
        engine.undo_move()
    
    # Test 4: KI-Zug berechnen
    print("4. KI-Zug berechnen...")
    best_move = engine.search_algorithm.computer_move()
    if best_move:
        print(f"   KI-Zug gefunden: {engine.search_algorithm._move_to_notation(best_move)}")
    else:
        print("   ❌ Kein KI-Zug gefunden")
    
    print("=== TEST ABGESCHLOSSEN ===")

if __name__ == "__main__":
    test_ki_basic()
